
`--------------
` Lighting Setup
`--------------
function LightingSetUp()

   `Globals
      global Lighting_Screen as Vec2Float
      global Lighting_CameraPosition as Vec3Float
      global Lighting_CameraAngle as Vec3Float
      global Lighting_CameraDir as Vec3Float
      global Lighting_CameraData as Vec4Float
      global Lighting_Fog as Vec4Float
      global Lighting_AmbientColor as Vec3Float
      global Lighting_ShadowsQuality as integer
      global Lighting_SSAOenabled as integer 
      global Lighting_LightDirection as Vec3Float
      global Lighting_LightDirectionAngle as Vec3Float
      global Lighting_LightDirectionColor as Vec4Float
      global Lighting_MaxLights as integer : Lighting_MaxLights=128 
      global Lighting_MaxShadows as integer : Lighting_MaxShadows=12 
      global Lighting_LightsCount as integer : Lighting_LightsCount=-1
      global Lighting_LightsFreeUp as integer
      global Lighting_LightsActiveCount as integer : Lighting_LightsActiveCount=-1
      global Lighting_LightsActiveFind as integer
      global Lighting_LightInScreenCount as integer : Lighting_LightInScreenCount=-1
      global Lighting_LightUpdateCount as integer : Lighting_LightUpdateCount=-1
      global Lighting_LightUpdateMaskCount as integer : Lighting_LightUpdateMaskCount=-1
      global Lighting_LightTileRange as float
      global Lighting_LightTilePixel as integer 
      global Lighting_LightArrayFreeUp as integer : Lighting_LightArrayFreeUp=1
      global Lighting_PointLightFreeUp as integer : Lighting_PointLightFreeUp=1
      global Lighting_PointLightEfectsCount as integer : Lighting_PointLightEfectsCount=-1
      global Lighting_PointLightDrawCount1 as integer : Lighting_PointLightDrawCount1=-1
      global Lighting_PointLightDrawCount2 as integer : Lighting_PointLightDrawCount2=-1
      global Lighting_SpotLightFreeUp as integer : Lighting_SpotLightFreeUp=1
      global Lighting_SpotLightEfectsCount as integer : Lighting_SpotLightEfectsCount=-1
      global Lighting_SpotLightDrawCount1 as integer : Lighting_SpotLightDrawCount1=-1
      global Lighting_SpotLightDrawCount2 as integer : Lighting_SpotLightDrawCount2=-1
      global Lighting_ShadowsMask as integer
      global Lighting_ShadowMapDirSize as integer : Lighting_ShadowMapDirSize=1200
      global Lighting_ShadowMapPointSize as integer : Lighting_ShadowMapPointSize=500
      global Lighting_ShadowMapSpotSize as integer : Lighting_ShadowMapSpotSize=800
      global Lighting_ShadowsNoise as float
      global Lighting_EffectsCount as integer : Lighting_EffectsCount=-1
      global Lighting_ObjectsCount as integer : Lighting_ObjectsCount=-1
      global Lighting_ObjectsShadowUpdateCount as integer : Lighting_ObjectsShadowUpdateCount=-1
      global Lighting_ObjectsFreeUp as integer
      global Lighting_ObjectsActiveFind as integer
      global Lighting_ObjectsActiveCount as integer : Lighting_ObjectsActiveCount=-1
      global Lighting_ObjectsActiveStaticCount as integer : Lighting_ObjectsActiveStaticCount=-1
      global Lighting_ObjectsActiveAlphaCount as integer : Lighting_ObjectsActiveAlphaCount=-1
      global Lighting_ObjectsActiveShadowNullCount as integer : Lighting_ObjectsActiveShadowNullCount=-1
      global Lighting_ObjectsActiveShadow1NullCount as integer : Lighting_ObjectsActiveShadow1NullCount=-1
      global Lighting_ObjectsActiveShadow2NullCount as integer : Lighting_ObjectsActiveShadow2NullCount=-1
      global Lighting_ObjectsActiveShadow3NullCount as integer : Lighting_ObjectsActiveShadow3NullCount=-1
      global Lighting_ObjectsActiveShadow4NullCount as integer : Lighting_ObjectsActiveShadow4NullCount=-1
      global Lighting_ObjectsActiveShadowCullCount as integer : Lighting_ObjectsActiveShadowCullCount=-1
      Lighting_Screen.x=GetVirtualWidth() : Lighting_Screen.y=GetVirtualHeight()

   `Arrays
      global dim Lighting_Camera[10] as integer
      global dim Lighting_Image[20] as integer
      global dim Lighting_Object[10] as integer
      global dim Lighting_Effect[10] as integer
      global dim Lighting_Lights[] as Lighting_LightData
      global dim Lighting_LightUpdate[] as integer
      global dim Lighting_LightUpdateMask[] as integer
      global dim Lighting_LightsActive[] as integer
      global dim Lighting_LightInScreen[Lighting_MaxLights] as integer
      global dim Lighting_LightAssigned[Lighting_MaxLights] as integer
      global dim Lighting_LightIntersection[16] as integer
      global dim Lighting_LightMaskCount[7] as integer
      global dim Lighting_LightMasked[7] as integer
      global dim Lighting_LightTileObject[32] as integer
      global dim Lighting_LightTileEffect[32] as integer
      global dim Lighting_LightTileClipX[4] as vec4Float
      global dim Lighting_LightTileClipY[4] as vec4Float
      global dim Lighting_LightTileCount[4,4,3] as integer
      global dim Lighting_LightTileLight[4,4,3,Lighting_MaxLights] as integer
      global dim Lighting_LightArray[Lighting_MaxLights] as Lighting_LightShaderData
      global dim Lighting_PointLights[Lighting_MaxLights] as Lighting_LightShaderData
      global dim Lighting_PointLightEfects[8,4] as integer
      global dim Lighting_PointLightDraw1[Lighting_MaxLights] as integer
      global dim Lighting_PointLightDraw2[Lighting_MaxLights] as integer
      global dim Lighting_SpotLights[Lighting_MaxLights] as Lighting_LightShaderData
      global dim Lighting_SpotLightEfects[8,4] as integer
      global dim Lighting_SpotLightDraw1[Lighting_MaxLights] as integer
      global dim Lighting_SpotLightDraw2[Lighting_MaxLights] as integer
      global dim Lighting_ShadowDirectionalCamera[4] as integer
      global dim Lighting_ShadowDirectionalImage[4] as integer
      global dim Lighting_ShadowPointCamera[20,6] as integer
      global dim Lighting_ShadowPointImage[20,6] as integer
      global dim Lighting_ShadowPoint[20] as Lighting_LightShadowData
      global dim Lighting_ShadowPointLight[20] as integer
      global dim Lighting_ShadowSpotCamera[20] as integer
      global dim Lighting_ShadowSpotImage[20] as integer
      global dim Lighting_ShadowSpot[20] as Lighting_LightShadowData
      global dim Lighting_ShadowSpotLight[20] as integer
      global dim Lighting_ShadowPointNear[4] as integer
      global dim Lighting_ShadowSpotNear[4] as integer
      global dim Lighting_ShadowPointUse[4] as integer
      global dim Lighting_ShadowSpotUse[4] as integer
      global dim Lighting_ShadowRange[4] as float
      global dim Lighting_ShadowUpdate[2] as integer
      global dim Lighting_Effects[] as Lighting_EffectData
      global dim Lighting_Objects[] as Lighting_ObjectData
      global dim Lighting_ObjectsShadowUpdate[] as integer
      global dim Lighting_ObjectsActive[] as integer
      global dim Lighting_ObjectsActiveStatic[] as integer
      global dim Lighting_ObjectsActiveAlpha[] as integer
      global dim Lighting_ObjectsActiveShadowNull[] as integer
      global dim Lighting_ObjectsActiveShadow1Null[] as integer
      global dim Lighting_ObjectsActiveShadow2Null[] as integer
      global dim Lighting_ObjectsActiveShadow3Null[] as integer
      global dim Lighting_ObjectsActiveShadow4Null[] as integer
      global dim Lighting_ObjectsActiveShadowCull[] as integer
      for x=0 to 4
         for y=0 to 4
            Lighting_LightTileCount[x,y,0]=-1
            Lighting_LightTileCount[x,y,1]=-1
            Lighting_LightTileCount[x,y,2]=-1
            Lighting_LightTileCount[x,y,3]=-1
         next y
      next x
      Lighting_ShadowRange[1]=800 : Lighting_ShadowRange[2]=2400 : Lighting_ShadowRange[3]=7200 : Lighting_ShadowRange[4]=21600 : Lighting_ShadowRange[0]=21600
      FogSetColor(128,128,128,5000)
      AmbientSetColor(32,32,32)
      DirectionalLightSetAngle(45,-45,0)

   `Z Pre-pass/ SSAO/ Light Masks/ Tile Rendering
      Lighting_Image[1]=FreeUpImage(35000)
      Lighting_Camera[1]=CreateCamera()
      CameraToImage(Lighting_Camera[1],0,Lighting_Image[1],Lighting_Screen.x,Lighting_Screen.y) : `Depth
      SetImageMagFilter(Lighting_Image[1],0)
      SetImageMinFilter(Lighting_Image[1],0)
      Lighting_Image[2]=FreeUpImage(35000)
      Lighting_Camera[2]=CreateCamera()
      CameraToImage(Lighting_Camera[2],Lighting_Image[2],0,Lighting_Screen.y*0.5,Lighting_Screen.y*0.5) : `Clouds/SSAO
      Lighting_Image[3]=FreeUpImage(35000)
      Lighting_Camera[3]=CreateCamera()
      CameraToImage(Lighting_Camera[3],Lighting_Image[3],0,Lighting_Screen.x,Lighting_Screen.y) : `Shadow Mask B
      SetImageMagFilter(Lighting_Image[3],0)
      SetImageMinFilter(Lighting_Image[3],0)
      Lighting_Image[4]=FreeUpImage(35000)
      Lighting_Camera[4]=CreateCamera()
      CameraToImage(Lighting_Camera[4],Lighting_Image[4],0,Lighting_Screen.x,Lighting_Screen.y) : `Shadow Mask B
      SetImageMagFilter(Lighting_Image[4],0)
      SetImageMinFilter(Lighting_Image[4],0)
      Lighting_Image[5]=FreeUpImage(35000)
      Lighting_Camera[5]=CreateCamera()
      CameraToImage(Lighting_Camera[5],Lighting_Image[5],0,50,20) : `Light Tile data
      SetImageMagFilter(Lighting_Image[5],0) : SetImageMinFilter(Lighting_Image[5],0)

   `Images
      Lighting_Image[10]=FreeUpImage(35000)
      LoadTexture(Lighting_Image[10],"Shaders\Resources\null.png")
      Lighting_Image[11]=FreeUpImage(35000)
      SetGenerateMipmaps(0)
      LoadImage(Lighting_Image[11],"Shaders\Resources\noise.png")
      SetImageMagFilter(Lighting_Image[11],0) : SetImageMinFilter(Lighting_Image[11],0)
      SetImageWrapU(Lighting_Image[11],1) : SetImageWrapV(Lighting_Image[11],1)

   `Create Sky
      SkyCreate()

   `Tile Rendering Mesh
      Lighting_LightTileEffect[1]=CreateEffect()
      Lighting_LightTileObject[1]=FreeUpObject(35000)
      LoadEffectTechnique(Lighting_LightTileEffect[1],"Tiles","Shaders\Lighting\Tiles.vs","Shaders\Lighting\Tiles.ps")
      CameraToRenderTarget(Lighting_Camera[5],Lighting_LightTileObject[1])
      SetObjectEffect(Lighting_LightTileObject[1],Lighting_LightTileEffect[1],0)
      setobjectvisible(Lighting_LightTileObject[1],0)

   `Shadowmaps
      for x=1 to 4
         Lighting_ShadowDirectionalImage[x]=FreeUpImage(35000)
         Lighting_ShadowDirectionalCamera[x]=CreateCamera()
         CameraToImage(Lighting_ShadowDirectionalCamera[x],0,Lighting_ShadowDirectionalImage[x],Lighting_ShadowMapDirSize,Lighting_ShadowMapDirSize)
      next x
      for x=1 to Lighting_MaxShadows
         for f=1  to 6
            Lighting_ShadowPointImage[x,f]=FreeUpImage(35000)
            Lighting_ShadowPointCamera[x,f]=CreateCamera()
            if x>4
               CameraToImage(Lighting_ShadowPointCamera[x,f],0,Lighting_ShadowPointImage[x,f],Lighting_ShadowMapPointSize/2,Lighting_ShadowMapPointSize/2)
            else
               CameraToImage(Lighting_ShadowPointCamera[x,f],0,Lighting_ShadowPointImage[x,f],Lighting_ShadowMapPointSize,Lighting_ShadowMapPointSize)
            endif
         next f
         Lighting_ShadowSpotImage[x]=FreeUpImage(35000)
         Lighting_ShadowSpotCamera[x]=CreateCamera()
         if x>4
            CameraToImage(Lighting_ShadowSpotCamera[x],0,Lighting_ShadowSpotImage[x],Lighting_ShadowMapSpotSize/2,Lighting_ShadowMapSpotSize/2)
         else
            CameraToImage(Lighting_ShadowSpotCamera[x],0,Lighting_ShadowSpotImage[x],Lighting_ShadowMapSpotSize,Lighting_ShadowMapSpotSize)
         endif
      next x 

   `Directional Light Shadows
      Lighting_Object[1]=FreeUpObject(35000)
      Lighting_Effect[1]=CreateEffect()
      LoadEffectTechnique(Lighting_Effect[1],"Directional0","Shaders\Lighting\Directional\Directional.vs","Shaders\Lighting\Directional\Directional0.ps")
      LoadEffectTechnique(Lighting_Effect[1],"Directional1","Shaders\Lighting\Directional\Directional.vs","Shaders\Lighting\Directional\Directional1.ps")
      CameraToRenderTarget(Lighting_Camera[3],Lighting_Object[1])
      SetObjectEffect(Lighting_Object[1],Lighting_Effect[1],0)
      SetObjectImage(Lighting_Object[1],Lighting_Image[1],0)
      SetObjectImage(Lighting_Object[1],Lighting_ShadowDirectionalImage[1],1)
      SetObjectImage(Lighting_Object[1],Lighting_ShadowDirectionalImage[2],2)
      SetObjectImage(Lighting_Object[1],Lighting_ShadowDirectionalImage[3],3)
      SetObjectImage(Lighting_Object[1],Lighting_ShadowDirectionalImage[4],4)
      SetObjectImage(Lighting_Object[1],Lighting_Image[10],5)
      SetObjectTransparency(Lighting_Object[1],3)
      SetObjectBlendModes(Lighting_Object[1],1,1)
      SetObjectDepthWrite(Lighting_Object[1],0)
      SetObjectDepthReadMode(Lighting_Object[1],7)
      SetObjectVisible(Lighting_Object[1],0)

   `SSAO
      Lighting_Object[2]=FreeUpObject(35000)
      Lighting_Effect[2]=CreateEffect()
      LoadEffectTechnique(Lighting_Effect[2],"SSAO","Shaders\Lighting\Directional\SSAO.vs","Shaders\Lighting\Directional\SSAO.ps")
      SetEffectConstantVector(Lighting_Effect[2],"ViewSize",SetViewVec(1,Lighting_Screen.x,Lighting_Screen.y))
      CameraToRenderTarget(Lighting_Camera[2],Lighting_Object[2])
      SetObjectEffect(Lighting_Object[2],Lighting_Effect[2],0)
      SetObjectImage(Lighting_Object[2],Lighting_Image[1],0)
      SetObjectImage(Lighting_Object[2],Lighting_Image[11],1)
      SetObjectTransparency(Lighting_Object[2],3)
      SetObjectBlendModes(Lighting_Object[2],1,1)
      SetObjectDepthWrite(Lighting_Object[2],0)
      SetObjectDepthReadMode(Lighting_Object[2],7)
      SetObjectVisible(Lighting_Object[2],0)

endfunction

`--------------
` Lighting UpDate
`--------------
function LightingUpDate(iTimer as float)

   `Camera
      Lighting_CameraPosition.x=CameraPositionX(Lighting_Camera[0])
      Lighting_CameraPosition.y=CameraPositionY(Lighting_Camera[0])
      Lighting_CameraPosition.z=CameraPositionZ(Lighting_Camera[0])
      Lighting_CameraAngle.x=CameraAngleX(Lighting_Camera[0])
      Lighting_CameraAngle.y=CameraAngleY(Lighting_Camera[0])
      Lighting_CameraAngle.z=CameraAngleZ(Lighting_Camera[0])
      Lighting_CameraDir.x=CameraDirectionX(Lighting_Camera[0])
      Lighting_CameraDir.y=CameraDirectionY(Lighting_Camera[0])
      Lighting_CameraDir.z=CameraDirectionZ(Lighting_Camera[0])
      ViewMatrix(Lighting_Camera[0],200)
      ProjectionMatrix(Lighting_Camera[0],201)
      null=Inverse_Matrix4(202,200)
      null=Inverse_Matrix4(203,201)
      Multiply_Matrix4(204,200,201)
      Multiply_Matrix4(205,203,202)
      GetViewProjectFrustum(0,204)

   `Depth
      for o=0 to Lighting_ObjectsActiveAlphaCount
         tObject=Lighting_ObjectsActiveAlpha[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,0)
      next o
      SetEffectTechnique(Sky_Effect[1],"Depth")
      for e=0 to Lighting_EffectsCount
         if Lighting_Effects[e].InUse=1 
            tEffect=Lighting_Effects[e].Effect
            SetEffectTechnique(tEffect,"Depth")
         endif
      next e

   `Updates
      SkyUpdate(iTimer)
      ObjectsUpdate(iTimer)
      LightsUpdate(iTimer)

   `View Project Inverse
      set_vector4(1,Lighting_Screen.x,Lighting_Screen.y,0.06711056,0.00583715)
      tEffect=Lighting_Effect[1]
      SetShaderConstantByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ShadowNoise",Vector4Float[1].x,Vector4Float[1].y,Vector4Float[1].z,Vector4Float[1].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ViewProjInv",0,Matrix4Float[205,1].x,Matrix4Float[205,1].y,Matrix4Float[205,1].z,Matrix4Float[205,1].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ViewProjInv",1,Matrix4Float[205,2].x,Matrix4Float[205,2].y,Matrix4Float[205,2].z,Matrix4Float[205,2].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ViewProjInv",2,Matrix4Float[205,3].x,Matrix4Float[205,3].y,Matrix4Float[205,3].z,Matrix4Float[205,3].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ViewProjInv",3,Matrix4Float[205,4].x,Matrix4Float[205,4].y,Matrix4Float[205,4].z,Matrix4Float[205,4].w)
      tEffect=Lighting_Effect[2]
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"View",0,Matrix4Float[200,1].x,Matrix4Float[200,1].y,Matrix4Float[200,1].z,Matrix4Float[200,1].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"View",1,Matrix4Float[200,2].x,Matrix4Float[200,2].y,Matrix4Float[200,2].z,Matrix4Float[200,2].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"View",2,Matrix4Float[200,3].x,Matrix4Float[200,3].y,Matrix4Float[200,3].z,Matrix4Float[200,3].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"View",3,Matrix4Float[200,4].x,Matrix4Float[200,4].y,Matrix4Float[200,4].z,Matrix4Float[200,4].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProj",0,Matrix4Float[204,1].x,Matrix4Float[204,1].y,Matrix4Float[204,1].z,Matrix4Float[204,1].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProj",1,Matrix4Float[204,2].x,Matrix4Float[204,2].y,Matrix4Float[204,2].z,Matrix4Float[204,2].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProj",2,Matrix4Float[204,3].x,Matrix4Float[204,3].y,Matrix4Float[204,3].z,Matrix4Float[204,3].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProj",3,Matrix4Float[204,4].x,Matrix4Float[204,4].y,Matrix4Float[204,4].z,Matrix4Float[204,4].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProjInv",0,Matrix4Float[205,1].x,Matrix4Float[205,1].y,Matrix4Float[205,1].z,Matrix4Float[205,1].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProjInv",1,Matrix4Float[205,2].x,Matrix4Float[205,2].y,Matrix4Float[205,2].z,Matrix4Float[205,2].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProjInv",2,Matrix4Float[205,3].x,Matrix4Float[205,3].y,Matrix4Float[205,3].z,Matrix4Float[205,3].w)
      SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ViewProjInv",3,Matrix4Float[205,4].x,Matrix4Float[205,4].y,Matrix4Float[205,4].z,Matrix4Float[205,4].w)
      for e=0 to Lighting_PointLightEfectsCount
         tEffect=Lighting_PointLightEfects[e,0]
         for s=0 to Effects[tEffect].ShaderCount
            SetShaderConstantByName(Effects[tEffect].Shader[s],"ShadowNoise",Vector4Float[1].x,Vector4Float[1].y,Vector4Float[1].z,Vector4Float[1].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",0,Matrix4Float[205,1].x,Matrix4Float[205,1].y,Matrix4Float[205,1].z,Matrix4Float[205,1].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",1,Matrix4Float[205,2].x,Matrix4Float[205,2].y,Matrix4Float[205,2].z,Matrix4Float[205,2].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",2,Matrix4Float[205,3].x,Matrix4Float[205,3].y,Matrix4Float[205,3].z,Matrix4Float[205,3].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",3,Matrix4Float[205,4].x,Matrix4Float[205,4].y,Matrix4Float[205,4].z,Matrix4Float[205,4].w)
         next s
      next e
      for e=0 to Lighting_SpotLightEfectsCount
         tEffect=Lighting_SpotLightEfects[e,0]
         for s=0 to Effects[tEffect].ShaderCount
            SetShaderConstantByName(Effects[tEffect].Shader[s],"ShadowNoise",Vector4Float[1].x,Vector4Float[1].y,Vector4Float[1].z,Vector4Float[1].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",0,Matrix4Float[205,1].x,Matrix4Float[205,1].y,Matrix4Float[205,1].z,Matrix4Float[205,1].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",1,Matrix4Float[205,2].x,Matrix4Float[205,2].y,Matrix4Float[205,2].z,Matrix4Float[205,2].w)
            SetShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",2,Matrix4Float[205,3].x,Matrix4Float[205,3].y,Matrix4Float[205,3].z,Matrix4Float[205,3].w)
            setShaderConstantArrayByName(Effects[tEffect].Shader[s],"ViewProjInv",3,Matrix4Float[205,4].x,Matrix4Float[205,4].y,Matrix4Float[205,4].z,Matrix4Float[205,4].w)
         next s
      next e

   `Render Depth Pre-Pass
      SetCameraPosition(1,Lighting_CameraPosition.x,Lighting_CameraPosition.y,Lighting_CameraPosition.z)
      SetCameraRotation(1,Lighting_CameraAngle.x,Lighting_CameraAngle.y,Lighting_CameraAngle.z)
      SetCameraRange(1,Lighting_CameraData.x,Lighting_CameraData.y)
      SetCameraFov(1,Lighting_CameraData.z) 
      SetCameraAspect(1,Lighting_CameraData.w)
      SetClearColor(0,0,0)
      SetRenderToImage(0,Lighting_Image[1])
      ClearScreen()
      SetObjectVisible(Sky_Object[1],1) 
      render3d()
      SetObjectVisible(Sky_Object[1],0) 

   `Render Clouds/ SSAO
      SetRenderToImage(Lighting_Image[2],0)
      ClearScreen()
      if Lighting_CameraPosition.y<Sky_CloudsHeight.x+(Sky_CloudsSize*Sky_CloudsHeight.y*4)
         SetObjectVisible(Sky_Object[2],1) 
         drawobject(Sky_Object[2])
         SetObjectVisible(Sky_Object[2],0) 
      endif
      if Lighting_CameraPosition.y>Sky_CloudsHeight.x 
         SetObjectVisible(Sky_Object[3],1) 
         drawobject(Sky_Object[3])
         SetObjectVisible(Sky_Object[3],0) 
      endif
      if Lighting_SSAOenabled=1
         SetObjectVisible(Lighting_Object[2],1) 
         drawobject(Lighting_Object[2])
         SetObjectVisible(Lighting_Object[2],0) 
      endif

   `Render Masks 
      SetRenderToImage(Lighting_Image[3],0)
      ClearScreen()
      for o=0 to Lighting_PointLightDrawCount1
         setobjectvisible(Lighting_PointLightDraw1[o],1)
         drawobject(Lighting_PointLightDraw1[o])
         setobjectvisible(Lighting_PointLightDraw1[o],0)
      next o
      for o=0 to Lighting_SpotLightDrawCount1
         setobjectvisible(Lighting_SpotLightDraw1[o],1)
         drawobject(Lighting_SpotLightDraw1[o])
         setobjectvisible(Lighting_SpotLightDraw1[o],0)
      next o
      if Lighting_LightDirectionColor.x>0 or Lighting_LightDirectionColor.y>0 or Lighting_LightDirectionColor.z>0
         SetObjectVisible(Lighting_Object[1],1)
         drawobject(Lighting_Object[1])
         SetObjectVisible(Lighting_Object[1],0)
      endif
      SetRenderToImage(Lighting_Image[4],0)
      ClearScreen()
      for o=0 to Lighting_PointLightDrawCount2
         setobjectvisible(Lighting_PointLightDraw2[o],1)
         drawobject(Lighting_PointLightDraw2[o])
         setobjectvisible(Lighting_PointLightDraw2[o],0)
      next o
      for o=0 to Lighting_SpotLightDrawCount2
         setobjectvisible(Lighting_SpotLightDraw2[o],1)
         drawobject(Lighting_SpotLightDraw2[o])
         setobjectvisible(Lighting_SpotLightDraw2[o],0)
      next o

   `Light Tile Data
      SetRenderToImage(Lighting_Image[5],0)
      ClearScreen()
      setobjectvisible(Lighting_LightTileObject[1],1)
      drawobject(Lighting_LightTileObject[1])
      setobjectvisible(Lighting_LightTileObject[1],0)

   `Frame Render
      for o=0 to Lighting_ObjectsActiveAlphaCount
         tObject=Lighting_ObjectsActiveAlpha[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,1)
      next o
      for e=0 to Lighting_EffectsCount
         if Lighting_Effects[e].InUse=1 
            tEffect=Lighting_Effects[e].Effect
            SetEffectTechnique(tEffect,"Lighting")
            SetShaderConstantByName(Effects[tEffect].Shader[0],"TileRange",Lighting_LightTileRange*0.25,0,0,0)
         endif
      next e
      SetEffectTechnique(Sky_Effect[1],"Lighting")
      SetClearColor(Cameras[Lighting_Camera[0]].Backdrop.x,Cameras[Lighting_Camera[0]].Backdrop.y,Cameras[Lighting_Camera[0]].Backdrop.z)
      SetRenderToScreen()
      SetObjectVisible(Sky_Object[1],1) 
      render3d()
      SetObjectVisible(Sky_Object[1],0) 

endfunction

`--------------
` Lighting Set Camera
`--------------
function LightingSetCamera(iCamera as integer,iNear as float,iFar as float,iFov as float,iAspect as float)
   Lighting_CameraData.x=iNear
   Lighting_CameraData.y=iFar
   Lighting_CameraData.z=iFov
   Lighting_CameraData.w=iAspect
   Lighting_Camera[0]=iCamera
   CameraRange(Lighting_Camera[0],Lighting_CameraData.x,Lighting_CameraData.y)
   CameraFov(Lighting_Camera[0],Lighting_CameraData.z)
   CameraAspect(Lighting_Camera[0],Lighting_CameraData.w)
endfunction



